/* ============ */
/* gapprobs.c	*/
/* ============ */
#include <mconf.h>
/* ==================================================================== */
/* CalcGapProbs - Calculates Probabilities Relating to the Gap Test	*/
/* ==================================================================== */
/* -------------------------------------------------------------------- */
/* This code reflects the algorithm given by D. E. Knuth, The Art of	*/
/* Computer Programming, Vol. 2, Seminumerical Algorithms, Second Ed.,	*/
/* Addison-Wesley, Reading (1981), page 61, equation 4.			*/
/* -------------------------------------------------------------------- */
void
CalcGapProbs(int  NumLengths, double LoLimit, double HiLimit,
	     double *GapProbs)
{
    int     k;
    double  BaseProb, CompProb, NextProb;

    BaseProb = HiLimit - LoLimit;
    CompProb = 1 - BaseProb;
    NextProb = BaseProb;

    for (k = 0; k < NumLengths-1; ++k)
    {
	GapProbs[k] = NextProb;
	NextProb *= CompProb;		/* p*(1-p)^k */
    }

    GapProbs[NumLengths-1] = powi(CompProb, NumLengths-1);
}
